/*
 * Decompiled with CFR 0.152.
 */
package com.actonomy.upload.client;

import com.actonomy.upload.client.Uploader;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("No files provided");
            return;
        }
        ArrayList files = Lists.newArrayList();
        for (String arg : args) {
            Path path = Paths.get(arg, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                files.add(path);
                continue;
            }
            System.err.printf("File does not exist: %s\n", path.toAbsolutePath());
            System.exit(-1);
        }
        Uploader uploader = new Uploader();
        for (Path file : files) {
            uploader.upload(file);
        }
    }
}

