/*
 * Decompiled with CFR 0.152.
 */
package com.actonomy.upload.client;

import com.google.common.base.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public abstract class ReportingInputStream
extends FilterInputStream {
    private final long interval;
    private long deadline;
    private long count;

    public ReportingInputStream(InputStream in, long time, TimeUnit unit) {
        super((InputStream)Preconditions.checkNotNull((Object)in));
        this.interval = unit.toNanos(time);
        this.deadline = System.nanoTime() + this.interval;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            this.count(1L);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count(result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count(result);
        return result;
    }

    private void count(long result) {
        this.count += result;
        long now = System.nanoTime();
        if (this.deadline < now) {
            this.deadline = now + this.interval;
            this.onRead();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    public abstract void onRead();

    public long readCount() {
        return this.count;
    }
}

