/*
 * Decompiled with CFR 0.152.
 */
package com.actonomy.upload.client;

import com.actonomy.upload.api.FinishedRequest;
import com.actonomy.upload.api.Part;
import com.actonomy.upload.api.UploadRequest;
import com.actonomy.upload.api.UploadResponse;
import com.actonomy.upload.api.UploadServiceGrpc;
import com.actonomy.upload.client.ReportingInputStream;
import com.actonomy.upload.client.utils.ByteSizeValue;
import com.google.common.io.ByteStreams;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class Uploader {
    private final UploadServiceGrpc.UploadServiceBlockingStub service;
    private final CloseableHttpClient client;

    public Uploader() throws SSLException {
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)"upload-api.actonomy.be", (int)443).keepAliveWithoutCalls(true).keepAliveTime(15L, TimeUnit.MINUTES).overrideAuthority("upload-api.actonomy.be")).sslContext(GrpcSslContexts.forClient().trustManager(Uploader.class.getResourceAsStream("/combined.crt")).build()).build();
        this.service = UploadServiceGrpc.newBlockingStub((Channel)channel);
        this.client = HttpClientBuilder.create().disableAutomaticRetries().build();
    }

    public void upload(Path path) throws IOException {
        System.out.println("Starting on " + String.valueOf(path));
        UploadResponse uploadResponse = this.service.upload(this.newUpload(path));
        int count = 0;
        List parts = uploadResponse.getPartsList();
        for (Part part : parts) {
            System.out.printf("\tPart %s/%s: %s%n", ++count, parts.size(), new ByteSizeValue(part.getLength()));
            HttpPut httpPut = new HttpPut(part.getUrl());
            httpPut.setEntity(this.newBody(path, part.getStart(), part.getLength()));
            try {
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPut);
                try {
                    if (response.getStatusLine().getStatusCode() == 200) continue;
                    System.out.printf("Upload failed! %s%n", response.getStatusLine());
                    return;
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (Exception ex) {
                System.out.printf("Failed to upload%n", new Object[0]);
                ex.printStackTrace();
                return;
            }
        }
        this.service.finished(this.newFinished(uploadResponse.getId()));
        System.out.printf("%s uploaded successfully.", path);
    }

    private UploadRequest newUpload(Path path) throws IOException {
        return UploadRequest.newBuilder().setFileName(path.getFileName().toString()).setSize(Files.size(path)).build();
    }

    private FinishedRequest newFinished(String id) {
        return FinishedRequest.newBuilder().setUploadId(id).build();
    }

    private HttpEntity newBody(Path path, long start, long length) throws IOException {
        try {
            FileChannel ch = FileChannel.open(path, StandardOpenOption.READ);
            InputStream is = Channels.newInputStream(ch.position(start));
            final long startTime = System.nanoTime();
            return new InputStreamEntity((InputStream)new ReportingInputStream(this, ByteStreams.limit((InputStream)is, (long)length), 30L, TimeUnit.SECONDS){

                @Override
                public void onRead() {
                    this.logProgress();
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    this.logProgress();
                }

                private void logProgress() {
                    long read = this.readCount();
                    long durationSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
                    String perSecond = new ByteSizeValue(durationSeconds > 0L ? read / durationSeconds : read).toString();
                    System.out.printf("\t\t%s @ %s/s%n", new ByteSizeValue(read), perSecond);
                }
            }, length, ContentType.APPLICATION_OCTET_STREAM);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to upload " + String.valueOf(path), e);
        }
    }
}

