/*
 * Decompiled with CFR 0.152.
 */
package com.actonomy.upload.client.utils;

public enum ByteSizeUnit {
    BYTES{

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toKB(long size) {
            return size / 1024L;
        }

        @Override
        public long toMB(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toGB(long size) {
            return size / 0x40000000L;
        }
    }
    ,
    KB{

        @Override
        public long toBytes(long size) {
            return ByteSizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return size;
        }

        @Override
        public long toMB(long size) {
            return size / 1024L;
        }

        @Override
        public long toGB(long size) {
            return size / 0x100000L;
        }
    }
    ,
    MB{

        @Override
        public long toBytes(long size) {
            return ByteSizeUnit.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return ByteSizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMB(long size) {
            return size;
        }

        @Override
        public long toGB(long size) {
            return size / 1024L;
        }
    }
    ,
    GB{

        @Override
        public long toBytes(long size) {
            return ByteSizeUnit.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return ByteSizeUnit.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMB(long size) {
            return ByteSizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGB(long size) {
            return size;
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long MAX = Long.MAX_VALUE;

    private static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKB(long size) {
        throw new AbstractMethodError();
    }

    public long toMB(long size) {
        throw new AbstractMethodError();
    }

    public long toGB(long size) {
        throw new AbstractMethodError();
    }
}

