/*
 * Decompiled with CFR 0.152.
 */
package com.actonomy.upload.client.utils;

import com.actonomy.upload.client.utils.ByteSizeUnit;
import java.io.Serializable;

public class ByteSizeValue
implements Serializable {
    private final long size;
    private final ByteSizeUnit sizeUnit;

    public ByteSizeValue(long bytes) {
        this(bytes, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long size, ByteSizeUnit sizeUnit) {
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    public static ByteSizeValue ofBytes(long bytes) {
        return new ByteSizeValue(bytes);
    }

    public int bytesAsInt() throws IllegalArgumentException {
        long bytes = this.bytes();
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size [" + this.toString() + "] is bigger than max int");
        }
        return (int)bytes;
    }

    public long bytes() {
        return this.sizeUnit.toBytes(this.size);
    }

    public long getBytes() {
        return this.bytes();
    }

    public long kb() {
        return this.sizeUnit.toKB(this.size);
    }

    public long getKb() {
        return this.kb();
    }

    public long mb() {
        return this.sizeUnit.toMB(this.size);
    }

    public long getMb() {
        return this.mb();
    }

    public long gb() {
        return this.sizeUnit.toGB(this.size);
    }

    public long getGb() {
        return this.gb();
    }

    public double kbFrac() {
        return (double)this.bytes() / 1024.0;
    }

    public double getKbFrac() {
        return this.kbFrac();
    }

    public double mbFrac() {
        return (double)this.bytes() / 1048576.0;
    }

    public double getMbFrac() {
        return this.mbFrac();
    }

    public double gbFrac() {
        return (double)this.bytes() / 1.073741824E9;
    }

    public double getGbFrac() {
        return this.gbFrac();
    }

    public String toString() {
        long bytes = this.bytes();
        double value = bytes;
        String suffix = "b";
        if (bytes >= 0x40000000L) {
            value = this.gbFrac();
            suffix = "gb";
        } else if (bytes >= 0x100000L) {
            value = this.mbFrac();
            suffix = "mb";
        } else if (bytes >= 1024L) {
            value = this.kbFrac();
            suffix = "kb";
        }
        return ByteSizeValue.format1Decimals(value, suffix);
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex == -1) {
                return p.substring(0, ix - 1) + suffix;
            }
            return p.substring(0, ix - 1) + p.substring(ex) + suffix;
        }
        if (ex == -1) {
            return p.substring(0, ix) + fraction + suffix;
        }
        return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue) throws IllegalArgumentException {
        return ByteSizeValue.parseBytesSizeValue(sValue, null);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, ByteSizeValue defaultValue) throws IllegalArgumentException {
        long bytes;
        if (sValue == null) {
            return defaultValue;
        }
        try {
            bytes = sValue.endsWith("k") || sValue.endsWith("K") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0) : (sValue.endsWith("kb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1024.0) : (sValue.endsWith("m") || sValue.endsWith("M") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1048576.0) : (sValue.endsWith("mb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1048576.0) : (sValue.endsWith("g") || sValue.endsWith("G") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.073741824E9) : (sValue.endsWith("gb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1.073741824E9) : (sValue.endsWith("b") ? Long.parseLong(sValue.substring(0, sValue.length() - 1)) : Long.parseLong(sValue)))))));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse [" + sValue + "]", e);
        }
        return new ByteSizeValue(bytes, ByteSizeUnit.BYTES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteSizeValue)) {
            return false;
        }
        ByteSizeValue that = (ByteSizeValue)o;
        if (this.size != that.size) {
            return false;
        }
        return this.sizeUnit == that.sizeUnit;
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.sizeUnit != null ? this.sizeUnit.hashCode() : 0);
        return result;
    }
}

